import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/data/models/promotional_slider_model/promotional_slider_model.dart';
import 'package:razinsoft_rider/data/repositories/interfaces/promotional_slider_repo_interface.dart';
import 'package:razinsoft_rider/domain/interfaces/promotional_slider_service_interface.dart';
import '../../core/errors/failure.dart';
import 'base_repository.dart';

class PromotionalSliderRepoImpl extends BaseRepository implements IPromotionalSliderRepo {
  final IPromotionalSliderService service;

  PromotionalSliderRepoImpl({required this.service});
  @override
  Future<Either<Failure, PromotionalSliderModel>> getPromotionalData() async => await safeApiCall(() async {
      final response = await service.getPromotionalData();
      return PromotionalSliderModel.fromJson(response.data);
    });

}
